/* ISLAMIC PRAYERS *****************************************\
 *                                                         *
 *  2004-2006 By Samir Alicehajic (samir@yildun.com)       *
 *  http://www.yildun.com                                  *
 *  Copyright (C) 2004-2006 Samir Alicehajic               *
 *  THIS SOURCE CODE IS FREE FOR USE IN THE NAME OF        *
 *	 ALLAH SUBHANAHU WA TA'ALA                              *
 *  This SOURCE CODE is distributed in the hope that it    *
 *  will be useful, but WITHOUT ANY WARRANTY; without even *
 *  the implied warranty of MERCHANTABILITY or             *
 *  FITNESS FOR A PARTICULAR PURPOSE.                      *
 *  However you can use part of this source code in your   *
 *  own software                                           *
 *                                                         *
\***********************************************************/
/*
  Copyright (C) 2002 Fayez Alhargan.
  King Abdulaziz City for Science and Technology
  Computer and Electronics Research Institute
  Riyadh, Saudi Arabia
  alhargan@kacst.edu.sa
  Tel:4813770 Fax:4813764
  This is a program that computes the Hijary dates for Umm-AlQura calendar
  the official calendar of the Kingdom of Saudi Arabia.
  version: opn1.2
  last modified 22-1-2003

  Modified version by Samir Alicehajic, AgnateMoslem.net at June 6. 2004.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser Library General Public License for more details.

*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
//#include <fstream.h>

#define pi 3.1415926535897932
#define DToR (pi / 180.0)
#define RToH (12 / pi)
#define EarthRadius 6378.14
#define HStartYear 1420
#define HEndYear 1450

char rgch1[500];

int MonthMap[]={19410,19396,19337,19093,13613,13741,15210,18132,19913,19858,19110,18774,12974,13677,13162,15189,19114,14669,13469,14685,12986,13749,17834,15701,19098,14638,12910,13661,15066,18132,18085};
short gmonth[14]={31,31,28,31,30,31,30,31,31,30,31,30,31,31};
short smonth[14]={31,30,30,30,30,30,29,31,31,31,31,31,31,30};
char dowl[][30]= { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char GregDays[][70] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
char GregMonths[12][50] = {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
char HijriMonths[12][50] = {"MuHarram", "Safar", "Raby` al-awal", "Raby` al-THaany", "Jumaada al-awal", "Jumaada al-THaany", "Rajab", "SHa`baan", "RamaDHaan", "SHawwal", "Thw al-Qi`dah", "Thw al-Hijjah"};
char DaysArabic[][35] = {"", "", "", "", "", "", ""};
char HijriMonthsArabic[][35] = { "   ", "", "", " ", " ", " ", " ", "", "", "", "", " ", " "};

int PrayingTimesCalculation(char *filesave, double Zonh, double longtud, double latud, int yg, int mg, int dg, int nd);
//int HijriCalendarCalculation(char *filesave, int yg, int mg, int dg, int nd);

void WritePrayerTime(FILE *dataout, double h, int bSec);
int OmAlQrahr(int year,int month,int day, double param[], double lst[]);
int BH2GA(int yh, int mh, int *yg, int *mg, int *dg, int *dayweek);
int G2HA(int yg, int mg, int dg, int *yh, int *mh, int *dh, int *dayweek);
int H2GA(int *yh, int *mh, int *dh, int *yg, int *mg, int *dg, int *dayweek);
void S2G(int ys, int ms, int ds, int *yg, int *mg, int *dg);
void G2S(int yg, int mg, int dg, int *ys, int *ms, int *ds);
double GCalendarToJD(int yg, int mg, double dg );
double JDToGCalendar(double JD, int *yy, int *mm, int *dd);
int GLeapYear(int year);
void GDateAjust(int *yg, int *mg, int *dg);
int DayWeek(long JulianD);
void JDToHCalendar(double JD, int *yh, int *mh, int *dh);
void JDToHACalendar(double JD, int *yh, int *mh, int *dh, int *dayweek);
double HCalendarToJD(int yh, int mh, int dh);
double HCalendarToJDA(int yh, int mh, int dh);
int HMonthLength(int yh, int mh);
double ip(double x);
int mod(double x, double y);
void GetRatior(int yg, int mg, int dg, double param[], double *IshRt, double *FajrRt);
double atanxy(double x, double y);
void EclipToEquator(double lmdr, double betar, double **alph, double **dltr);
double RoutinR2(double M, double e);
double GCalendarToJD(int yg, int mg, double dg );
double SunParamr(int yg, int mg, int dg, double ObsLon, double ObsLat, double TimeZone, double *Rise, double *Transit, double *Setting, double *RA, double *Decl, int *RiseSetFlags);

/*
int main(void)
{
   int year=2004, month=6, day=6;
   int yh, mh, dh, dayweek;

   GDateAjust(&year, &month, &day);
   G2HA(year, month, day, &yh, &mh, &dh, &dayweek);

   printf("%d,%d,%d,%s\n", yh, mh, dh, dowl[dayweek]);
   Sleep(5000);
	return 0;
}
*/
#pragma argsused
void WritePrayerTime(FILE *dataout, double h, int bSec)
{
	int hour, min, sec;

   hour = h;
   min = 60.0 * (double)(h - hour);
   if (bSec) {
	   sec = 3600.0 * (double)(h - hour - (min / 60.0));
   	if(sec > 30) min = min + 1;
   }
   if(min == 60)  { hour++; min = 0;}
   if(min < 0) min = -min;
   if (bSec) {
	   if(sec == 60)  { min++; sec = 0;}
   	if(sec < 0) sec = -sec;
   }
	fprintf(dataout, "%02d:%02d", hour, min);
   if (bSec) fprintf(dataout, ":%02d", sec);
   fprintf(dataout, "     ");
}
int PrayingTimesCalculation(char *filesave, double Zonh, double longtud, double latud, int yg, int mg, int dg, int nd)
{
	FILE *dataout;
   int day;
   double lst[14],param[12];
   int yg0, mg0, dg0, yh1, mh1, dh1, dayweek, i;

   if ((dataout = fopen(filesave, "w")) == NULL) {
   	printf("Can not open file: %s", filesave);
   	exit(0);
	}
   if (nd == 0) { dg=1; nd=gmonth[mg]; }
 	for(i = 0; i < 12; i++) lst[i] = 0;
   dg0 = dg - 1;
   mg0 = mg;
   yg0 = yg;
   fprintf(dataout, "               Praying times for a month: %s  %d\n", GregMonths[mg-1], yg);
   fprintf(dataout, "-------------------------------------------------------------------------\n");
   fprintf(dataout, "              Fajr     SHorwwQ    DHuhr     `ASr      MaGHrib  `ISHaa'\n");
   fprintf(dataout, "Date Day      Dawn     Sunrise    Noon    Afternoon   Sunset   Evening\n");
   fprintf(dataout, "-------------------------------------------------------------------------\n");
   for(day = 1; day <= nd; day++) {
   	dg0++;
	   GDateAjust(&yg0, &mg0, &dg0);
	  	G2HA(yg0, mg0, dg0, &yh1, &mh1, &dh1, &dayweek);

      //fprintf(dataout, "%d, %d, %d", yh1, mh1, dh1);

	   param[0] = 0.016388;  /* 59seconds, safety time */
	   param[1] = longtud * DToR;  /* Longitude in radians */
	   param[2] = latud * DToR;
	   param[3] = 300.0;
	   param[4] = 300.0;
	   param[5] = Zonh;     /* Time Zone difference from GMT S.A. +3*/
	   param[6] = 19 * DToR; /* Fajer Angle */
	   param[7] = 0; /* Isha Angle  */
	   param[8] = 1;    /* Aser=1,2  OmAlrqah Aser=1*/
	   param[9] = 45 * DToR;   /* Reference Angle suggested by Rabita */
	   param[10] = 1.5;  /* Isha fixed time from sunset */
	   param[11] = 4.2 * DToR; /* Eid Prayer Time   */
	   OmAlQrahr(yg0, mg0, dg0, param, lst);
	   fprintf(dataout, "%2d   %3s      ", dg0, dowl[dayweek]);
      for(i = 1; i <= 6; i++) WritePrayerTime(dataout, lst[i], 0);
      fprintf(dataout, "\n");
	}
	fclose(dataout);

	return 0;
}
/*
int HijriCalendarCalculation(char *filesave, int yg, int mg, int dg, int nd)
{
	FILE *dataout;
   int day;
   int yh1,mh1,dh1;
   int yh, mh, dh, dayweek;
   int yg0, mg0, dg0;
   double JD, JDH;

   if ((dataout = fopen(filesave, "w")) == NULL) {
   	printf("Can not open file: %s", filesave);
   	exit(0);
	}
   dg0 = dg - 1;
   mg0 = mg;
   yg0 = yg;
   for(day=1; day <= nd; day++) {
   	dg0++;
	   GDateAjust(&yg0, &mg0, &dg0);
	   JD = GCalendarToJD(yg0, mg0, dg0);
	  	G2HA(yg0, mg0, dg0, &yh1, &mh1, &dh1, &dayweek);
	  	JDH = HCalendarToJDA(yh1, mh1, dh1);
      fprintf(dataout, "JG  = %f %d - %d - %d\n", JD, yh1, mh1, dh1);
      fprintf(dataout, "JH1 = %f %d - %d - %d\n", JDH, yh1, mh1, dh1);
	   JDToHACalendar(JDH, &yh, &mh, &dh);
	   JD = HCalendarToJDA(yh, mh, dh);
      fprintf(dataout, "JH2 = %f %d - %d - %d\n", JD, yh, mh, dh);
   }
   fprintf(dataout, "\n\n");
	fclose(dataout);
	return 0;
}
*/






int BH2GA(int yh, int mh, int *yg, int *mg, int *dg, int *dayweek)
{
	int flag;
  	long JD;
  	double GJD;

  	if(mh < 1) mh = 12;
  	if(mh > 12) mh = 1;
  	if(yh < HStartYear) yh = HStartYear;
  	if(yh > HEndYear) yh = HEndYear;

   GJD = HCalendarToJDA(yh, mh, 1);
   JDToGCalendar(GJD, yg, mg, dg);
   JD = GJD;
   *dayweek = (JD + 1) % 7;
   flag = 1;

 	return flag;
}
double HCalendarToJDA(int yh, int mh, int dh)
{
	int flag, Dy, m, b;
  	long JD;
  	double GJD;

   JD = HCalendarToJD(yh, 1, 1);
   Dy = MonthMap[yh - HStartYear] / 4096;
   GJD = JD - 3 + Dy;
   b = MonthMap[yh - HStartYear];
   b = b - Dy * 4096;
   for(m = 1; m < mh; m++) {
   	flag = b % 2;
    	if(flag) Dy = 30;
      else Dy = 29;
    	GJD = GJD + Dy;
    	b = (b - flag) / 2;
   }
   GJD = GJD + dh - 1;

   return GJD;
}
int HMonthLength(int yh, int mh)
{
	int flag, Dy, m, b;

  	if(yh < HStartYear || yh > HEndYear) Dy = 0;
 	else {
   	Dy = MonthMap[yh - HStartYear] / 4096;
   	b = MonthMap[yh - HStartYear];
   	b = b - Dy * 4096;
    	for(m = 1; m <= mh; m++) {
      	flag = b % 2;
      	if(flag) Dy = 30;
         else Dy = 29;
      	b = (b - flag) / 2;
     	}
	}
   return Dy;
}
int DayinYear(int yh, int mh, int dh)
{
	int flag, Dy, m, b, DL;

  	if(yh < HStartYear || yh > HEndYear) DL = 0;
 	else {
   	Dy = MonthMap[yh - HStartYear] / 4096;
   	b = MonthMap[yh - HStartYear];
   	b = b - Dy * 4096;
   	DL = 0;
    	for(m = 1; m <= mh; m++) {
      	flag = b % 2;
      	if(flag) Dy = 30;
         else Dy = 29;
      	b = (b - flag) / 2;
      	DL = DL + Dy;
     	}
   	DL = DL + dh;
	}
   return DL;
}
int HYearLength(int yh)
{
	int flag, Dy, m, b, YL;

  	if(yh < HStartYear || yh > HEndYear) YL = 0;
 	else {
   	Dy = MonthMap[yh - HStartYear] / 4096;
   	b = MonthMap[yh - HStartYear];
   	b = b-Dy * 4096;
   	flag = b % 2;
   	if(flag) YL = 30;
      else YL = 29;
    	for(m = 2; m <= 12; m++) {
      	flag = b % 2;
      	if(flag) Dy = 30;
         else Dy = 29;
      	b = (b - flag) / 2;
      	YL = YL + Dy;
     	}
	}
   return YL;
}
int G2HA(int yg, int mg, int dg, int *yh, int *mh, int *dh, int *dayweek)
{
	int  yh1, mh1, dh1;
   int  yh2, mh2;
   int  yg1, mg1, dg1;
   int  df, dw2;
  	int flag = 0;
  	long J;
  	double GJD, HJD;

   GJD = GCalendarToJD(yg, mg, dg + 0.5);
   JDToHCalendar(GJD,&yh1, &mh1, &dh1);

   //sprintf(rgch1, "%f, %lu, %lu, %lu", GJD, yh1, mh1, dh1);
   //MessageBox(NULL, rgch1, NULL, MB_OK);

   HJD = HCalendarToJDA(yh1, mh1, dh1);
   df = GJD - HJD;
   dh1 = dh1 + df;
   while(dh1 > 30) {
   	dh1 = dh1 - HMonthLength(yh1, mh1);
     	mh1++;
     	if(mh1 > 12) { yh1++; mh1 = 1;}
   }
   if(dh1 == 30) {
   	mh2 = mh1 + 1;
    	yh2 = yh1;
    	if(mh2 > 12) { mh2 = 1; yh2++; }
    	BH2GA(yh2, mh2, &yg1, &mg1, &dg1, &dw2);
    	if(dg == dg1) { yh1 = yh2; mh1 = mh2; dh1 = 1; }
	}
   J = (GCalendarToJD(yg, mg, dg) + 2);
   *dayweek = J % 7;
   *yh = yh1;
   *mh = mh1;
   *dh = dh1;

	return flag;
}
int H2GA(int *yh, int *mh, int *dh, int *yg, int *mg, int *dg, int *dayweek)
{
	int found, yh1, mh1, yg1, mg1, dg1, dw1;

   if(*dh > 30) { *dh = 1; (*mh)++; }
   if(*dh < 1)  { *dh = 1; (*mh)--; }
   if(*mh > 12) { *mh = 1; (*yh)++; }
   if(*mh < 1)  { *mh = 12; (*yh)--; }

   found = BH2GA(*yh, *mh, yg, mg, dg, dayweek);
   *dg = *dg + *dh - 1;
   GDateAjust(yg, mg, dg);
   *dayweek = *dayweek + *dh - 1;
   *dayweek = *dayweek % 7;

	if(*dh == 30) {
   	mh1 = *mh+1;
    	yh1 = *yh;
    	if(mh1 > 12) { mh1 = mh1 - 12; yh1++; }
    	found = BH2GA(yh1, mh1, &yg1, &mg1, &dg1, &dw1);
    	if(*dg == dg1) { *yh = yh1; *mh = mh1; *dh = 1; }
	}
   return found;
}
double JDToGCalendar(double JD, int *yy, int *mm, int *dd)
{
	double A, B, F;
	int alpha, C, E;
	long D, Z;

  	Z = (long)floor (JD + 0.5);
  	F = (JD + 0.5) - Z;
  	alpha = (int)((Z - 1867216.25) / 36524.25);
  	A = Z + 1 + alpha - alpha / 4;
  	B = A + 1524;
  	C = (int) ((B - 122.1) / 365.25);
  	D = (long) (365.25 * C);
  	E = (int) ((B - D) / 30.6001);
  	*dd = B - D - floor (30.6001 * E) + F;
  	if (E < 14) *mm = E - 1;
  	else *mm = E - 13;
  	if (*mm > 2) *yy = C - 4716;
  	else *yy = C - 4715;
  	F = F * 24.0;

  	return F;
}
double GCalendarToJD(int yy, int mm, double dd)
{
	int A, B, m, y;
	double T1, T2, Tr;

  	if (mm > 2) { y = yy; m = mm; }
  	else { y = yy - 1; m = mm + 12; }
  	A = y / 100;
  	B = 2 - A + A / 4;

  	T1 = ip (365.25 * (y + 4716));
  	T2 = ip (30.6001 * (m + 1));
  	Tr = T1 + T2 + dd + B - 1524.5;

  	return Tr;
}
int GLeapYear(int year)
{
	int T = 0;

   if(year % 4 == 0) T = 1;
   if(year % 100 == 0) {
   	T = 0;
	 	if(year % 400 == 0) T = 1;
   }
	return T;
}
void GDateAjust(int *yg, int *mg, int *dg)
{
	int dys;

   if(*mg < 1) {
   	*mg = 12 + *mg;
	   *yg = *yg - 1;
   }
	if(*dg < 1) {
   	*mg = *mg - 1;
	   *dg = gmonth[*mg] + *dg;
	   if(*mg == 2) *dg = *dg + GLeapYear(*yg);
	   if(*mg < 1) {
      	*mg = 12 + *mg;
	     	*yg = *yg - 1;
      }
   }
   if(*mg > 12) {
   	*mg = *mg - 12;
	   *yg = *yg + 1;
   }
   if(*mg == 2) { dys = gmonth[*mg] + GLeapYear(*yg); }
   else dys = gmonth[*mg];
   if(*dg > dys) {
   	*dg = *dg - dys;
      *mg = *mg + 1;
      if(*mg == 2) {
      	dys = gmonth[*mg] + GLeapYear(*yg);  /* number of days in the current month */
	      if(*dg > dys) {
				*dg = *dg - dys;
				*mg = *mg + 1;
         }
      }
      if(*mg > 12) {
      	*mg = *mg - 12;
	     	*yg = *yg + 1;
      }
   }
}
int DayWeek(long JulianD)
{
	return (int)((JulianD + 1) % 7);
}
double HCalendarToJD(int yh, int mh, int dh)
{
 	double md, yd;

 	md = (mh - 1.0) * 29.530589;
 	yd = (yh - 1.0) * 354.367068 + md + dh - 1.0;
 	yd = yd + 1948439.0;

 	return yd;
}
void JDToHCalendar(double JD, int *yh, int *mh, int *dh)
{
	double md, yd;

 	yd = JD - 1948439.0;
 	md = mod(yd, 354.367068);
 	*dh = mod(md + 0.5,29.530589) + 1;
 	*mh = (md / 29.530589) + 1;
 	yd = yd - md;
 	*yh = yd / 354.367068 + 1;
 	if(*dh > 30) { *dh = *dh - 30; (*mh)++; }
 	if(*mh > 12) { *mh = *mh - 12; (*yh)++; }
}
void JDToHACalendar(double JD, int *yh, int *mh, int *dh, int *dayweek)
{
   long J;
	int  yh1, mh1, dh1;
   int  df;
  	double HJD;

	JDToHCalendar(JD, &yh1, &mh1, &dh1);
   HJD = HCalendarToJDA(yh1, mh1, dh1);
   df = JD + 0.5 - HJD;
   dh1 = dh1 + df;
   while(dh1 > 30) {
   	dh1 = dh1 - HMonthLength(yh1, mh1);
     	mh1++;
     	if(mh1 > 12) { yh1++; mh1=1;}
   }
   if(dh1 == 30 && HMonthLength(yh1, mh1) < 30) { dh1 = 1; mh1++; }
   if(mh1 > 12) { mh1 = 1; yh1++; }

	J = JD + 2;
   *dayweek = J % 7;
   *yh = yh1;
   *mh = mh1;
   *dh = dh1;
}
double ip(double x)
{
	double  tmp;

   modf(x, &tmp);
  	return tmp;
}
int mod(double x, double y)
{
	int r;
  	double d;

  	d = x / y;
  	r = d;
  	if(r < 0) r--;
  	d = x - y * r;
  	r = d;
 	return r;
}
int IsValid(int yh, int mh, int dh)
{
	int valid;

  	valid = 1;
  	if(yh < HStartYear ||   yh > HEndYear) valid = 0;
  	if(mh < 1 || mh > 12 || dh < 1) valid = 0;
   else if(dh > HMonthLength(yh, mh)) valid = 0;

  	return valid;
}

double atanxy(double x, double y)
{
	double argm;

   if(x == 0)  argm = 0.5 * pi;
   else argm = atan(y / x);
	if(x > 0 && y < 0) argm = 2.0 * pi + argm;
   if(x < 0) argm = pi + argm;
	return argm;
}
void EclipToEquator(double lmdr, double betar, double **alph, double **dltr)
{
	double eps = 23.441884;
 	double sdlt, epsr;
 	double x, y;
 	double rad = 0.017453292;

 	epsr = eps * rad;
 	sdlt = sin(betar) * cos(epsr) + cos(betar) * sin(epsr) * sin(lmdr);
 	**dltr = asin(sdlt);
 	y = sin(lmdr) * cos(epsr) - tan(betar) * sin(epsr);
 	x = cos(lmdr);
 	**alph = atanxy(x, y);
}
double RoutinR2(double M, double e)
{
	double dt = 1, dE, Ec;

  	Ec = M;
  	while(fabs(dt) > 1e-9) {
   	dt = Ec - e * sin(Ec) - M;
    	dE = dt / (1 - e * cos(Ec));
    	Ec = Ec - dE;
	}
 	return Ec;
}
double SunParamr(int yg, int mg, int dg, double ObsLon, double ObsLat, double TimeZone, double *Rise, double *Transit, double *Setting, double *RA, double *Decl, int *RiseSetFlags)
{
	double UT, ET, y, L, e, M;
  	double T, JD, Ec;
  	double tnv, v, tht;
  	double K, angl, T1, T2, H, cH;
  	*RiseSetFlags = 0;

  	JD = GCalendarToJD(yg, mg, dg);
  	T = (JD + (TimeZone / 24.0) - 2451545.0) / 36525.0;

  	L = 279.6966778 + 36000.76892 * T + 0.0003025 * T * T;
  	while(L > 360) L = L - 360;
  	while(L < 0) L = L + 360;
  	L = L * pi / 180.0;

  	M = 358.47583 + 35999.04975 * T - 0.00015 * T * T - 0.0000033 * T * T * T;
  	while(M > 360) M = M - 360;
  	while(M<0) M = M + 360;
  	M = M * pi / 180.0;

  	e = 0.01675104 - 0.0000418 * T - 0.000000126 * T * T;
  	Ec = 23.452294 - 0.0130125 * T - 0.00000164 * T * T + 0.000000503 * T * T * T;
  	Ec=Ec*pi/180.0;

  	y = tan(0.5 * Ec);
  	y = y * y;
  	ET = y * sin(2 * L) - 2 * e * sin(M) + 4 * e * y * sin(M) * cos(2 * L) - 0.5 * y * y * sin(4 * L) - 5 * 0.25 * e * e * sin(2 * M);
  	UT = ET * 180.0 / (15.0 * pi);

  	Ec = RoutinR2(M, e);
  	tnv = sqrt((1 + e) / (1 - e)) * tan(0.5 * Ec);
  	v = 2.0 * atan(tnv);
  	tht = L + v - M;

   //sprintf(rgch1, "%f, %f", *RA, *Decl);
   //MessageBox(NULL, rgch1, "111111", MB_OK);
  	EclipToEquator(tht, 0, &RA, &Decl);

  	K = 12 - UT - TimeZone + ObsLon * 12.0 / pi;
  	*Transit = K;
   angl = (-0.833333) * DToR;
   T1 = (sin(angl) - sin(*Decl) * sin(ObsLat));
   T2 = (cos(*Decl) * cos(ObsLat));
   cH = T1 / T2;
   if(cH > 1) { *RiseSetFlags = 16; cH = 1; }
   H = acos(cH);
   H = H * 12.0 / pi;
   *Rise = K - H;
   *Setting = K + H;

   return JD;
}

/*
  For international prayer times see Islamic Fiqah Council of the Muslim
  World League:  Saturday 12 Rajeb 1406H, concerning prayer times and fasting
  times for countries of high latitudes.
  This program is based on the above.
*/
/*****************************************************************************/
/* Name:    OmAlQrah                                                         */
/* Type:    Procedure                                                        */
/* Purpose: Compute prayer times and sunrise                                 */
/* Arguments:                                                                */
/*   yg,mg,dg : Date in Greg                                                 */
/*   param[0]: Safety time  in hours should be 0.016383h                     */
/*   longtud,latud: param[1],[2] : The place longtude and latitude in radians*/
/*   HeightdifW : param[3]: The place western herizon height difference in meters */
/*   HeightdifE : param[4]: The place eastern herizon height difference in meters */
/*   Zonh :param[5]: The place zone time dif. from GMT  West neg and East pos*/
/*          in decimal hours                                                 */
/*  fjrangl: param[6]: The angle (radian) used to compute                    */
/*            Fajer prayer time (OmAlqrah  -19 deg.)                         */
/*  ashangl: param[7]: The angle (radian) used to compute Isha  prayer time  */
/*          ashangl=0 then use  (OmAlqrah: ash=SunSet+1.5h)                  */
/*  asr  : param[8]: The Henfy (asr=2) Shafi (asr=1, Omalqrah asr=1)         */
/*  param[9]: latude (radian) that should be used for places above -+65.5    */
/*            should be 45deg as suggested by Rabita                         */
/*   param[10]: The Isha fixed time from Sunset                              */
/*  Output:                                                                  */
/*  lst[]: lst[n], 1:Fajer 2:Sunrise 3:Zohar 4:Aser  5:Magreb  6:Ishe        */
/*                 7:Fajer using exact Rabita method for places >48          */
/*                 8:Ash   using exact Rabita method for places >48          */
/*                 9: Eid Prayer Time                                        */
/*          for places above 48 lst[1] and lst[6] use a modified version of  */
/*          Rabita method that tries to eliminate the discontinuity          */
/*         all in 24 decimal hours                                           */
/*         returns flag:0 if there are problems, flag:1 no problems          */
/*****************************************************************************/
int OmAlQrahr(int yg,int mg,int dg, double param[], double lst[])
{
	int flag = 1, flagrs, problm = 0;
   double RA, Decl, Rise, Transit, Setting, SINd, COSd, act, H, angl, K, cH, X, MaxLat;
   double H0, Night, IshRt, FajrRt, HightCorWest, HightCorEast, IshFix, FajrFix;

  	SunParamr(yg, mg, dg, -param[1], param[2], -param[5], &Rise, &Transit, &Setting, &RA, &Decl, &flagrs);
  	SINd = sin(Decl) * sin(param[2]);
  	COSd = cos(Decl) * cos(param[2]);
   K = Transit;
   HightCorWest = 0;
   HightCorEast = 0;
   if(flagrs == 0 && fabs(param[2]) < 0.79 && (param[4] != 0 || param[3] != 0)) {
   	angl = -0.83333 * DToR;
    	cH = (sin(angl) - SINd) / (COSd);
    	H0 = acos(cH);
    	X = EarthRadius * 1000.0;
    	angl = -0.83333 * DToR + (0.5 * pi - asin(X / (X + param[3])));
    	cH = (sin(angl) - SINd) / (COSd);
    	HightCorWest = acos(cH);
    	HightCorWest = (H0 - HightCorWest) * (RToH);
    	angl = -0.83333 * DToR + (0.5 * pi - asin(X / (X + param[4])));
    	cH = (sin(angl) - SINd) / (COSd);
    	HightCorEast = acos(cH);
    	HightCorEast = (H0 - HightCorEast) * (RToH);
	}
  	if(!(flagrs == 0 && fabs(Setting - Rise) > 1 && fabs(Setting - Rise) < 23)) {
   	problm = 1;
     	if(param[2] < 0) MaxLat = -fabs(param[9]);
      else MaxLat = fabs(param[9]);
     	SunParamr(yg, mg,dg, -param[1], MaxLat, -param[5], &Rise, &Transit, &Setting, &RA, &Decl, &flagrs);
     	K = Transit;
     	SINd = sin(Decl) * sin(MaxLat);
     	COSd = cos(Decl) * cos(MaxLat);
   }
   if(K < 0) K = K + 24;
   lst[2] = Rise - HightCorEast;
   lst[3] = K + param[0];
   lst[5] = Setting + HightCorWest + param[0];
   if(problm) act = param[8] + tan(fabs(Decl - MaxLat));
   else act = param[8] + tan(fabs(Decl - param[2]));
   angl = atan(1.0 / act);
   cH = (sin(angl) - SINd) / (COSd);
   if(fabs(cH) > 1.0) { H = 3.5; flag = 0; }
  	else { H = acos(cH); H = H * RToH; }
   lst[4] = K + H + param[0];

   angl = -param[6];
  	cH = (sin(angl) - SINd) / (COSd);
  	if(fabs(param[2]) < 0.83776) {
   	H = acos(cH);
     	H = H * RToH;
     	lst[1] = K - (H + HightCorEast) + param[0];
     	lst[7] = lst[1];
  	}
 	else {
   	if(param[2] < 0) GetRatior(yg, 12, 21, param, &IshFix, &FajrFix);
	 	else GetRatior(yg, 6, 21, param, &IshFix, &FajrFix);

   	if(fabs(cH) > (0.45 + 1.3369 * param[6])) {
      	Night = 24 - (Setting - Rise);
      	lst[1] = Rise - Night * FajrFix;
   	}
  		else {
     		H = acos(cH);
     		H = H * RToH;
     		lst[1] = K - (H + HightCorEast) + param[0];
      }
   	lst[7] = lst[1];
   	if(fabs(cH) > 1) {
     		GetRatior(yg, mg, dg, param, &IshRt, &FajrRt);
     		Night = 24 - (Setting - Rise);
     		lst[7] = Rise - Night * FajrRt;
   	}
  		else {
     		H = acos(cH);
     		H = H * RToH;
     		lst[7] = K - (H + HightCorEast) + param[0];
      }
  	}
   if(param[7] != 0) {
   	angl = -param[7];
      cH = (sin(angl) - SINd) / (COSd);
      if(fabs(param[2]) < 0.83776) {
			H = acos(cH);
			H = H * RToH;
			lst[6] = K + (H + HightCorWest + param[0]);
			lst[8] = lst[6];
   	}
    	else {
     		if(fabs(cH) > (0.45 + 1.3369 * param[6])) {
	  			Night = 24 - (Setting - Rise);
	  			lst[6] = Setting+Night * IshFix;
			}
       	else {
				H = acos(cH);
				H = H * RToH;
				lst[6] = K + (H + HightCorWest + param[0]);
       	}

      	if(fabs(cH) > 1.0) {
	  			GetRatior(yg, mg, dg, param, &IshRt, &FajrRt);
	  			Night = 24 - (Setting - Rise);
	  			lst[8] = Setting + Night * IshRt;
			}
       	else {
				H = acos(cH);
				H = H * RToH;
				lst[8] = K + (H + HightCorWest + param[0]);
       	}
   	}
   }
   else {
   	lst[6] = lst[5] + param[10];
      lst[8] = lst[6];
   }
   angl = param[11];
  	cH = (sin(angl) - SINd) / (COSd);
  	if((fabs(param[2]) < 1.134 || flagrs == 0) && fabs(cH) <= 1.0) {
   	H = acos(cH);
     	H = H * RToH;
     	lst[9] = K - (H + HightCorEast) + param[0];
  	}
 	else {
   	lst[9] = lst[2] + 0.25;
  	}
   return flag;
}
//Function to obtain the ratio of the start time of Isha and Fajr at a referenced latitude (45deg suggested by Rabita) to the night length
void GetRatior(int yg, int mg, int dg, double param[], double *IshRt, double *FajrRt)
{
	int flagrs;
   double RA, Decl, Rise, Transit, Setting, SINd, COSd, H, angl, cH, MaxLat, FjrRf, IshRf, Night;

   if(param[2] < 0) MaxLat = -fabs(param[9]);
   else MaxLat = fabs(param[9]);
   SunParamr(yg, mg, dg, -param[1], MaxLat, -param[5], &Rise, &Transit, &Setting, &RA, &Decl, &flagrs);
   SINd = sin(Decl) * sin(MaxLat);
   COSd = cos(Decl) * cos(MaxLat);
   Night = 24 - (Setting - Rise);
   angl = -param[6];
   cH = (sin(angl) - SINd) / (COSd);
   H = acos(cH);
   H = H * RToH;
   FjrRf = Transit - H - param[0];
   if(param[7] != 0) {
   	angl = -param[7];
      cH = (sin(angl) - SINd) / (COSd);
      H = acos(cH);
      H = H * RToH;
      IshRf = Transit + H + param[0];
   }
   else { IshRf = Setting + param[10]; }
   *IshRt = (IshRf - Setting) / Night;
   *FajrRt = (Rise - FjrRf) / Night;

	return;
}

