/* ISLAMIC PRAYERS *****************************************\
 *                                                         *
 *  2004-2006 By Samir Alicehajic (samir@yildun.com)       *
 *  http://www.yildun.com                                  *
 *  Copyright (C) 2004-2006 Samir Alicehajic               *
 *  THIS SOURCE CODE IS FREE FOR USE IN THE NAME OF        *
 *	 ALLAH SUBHANAHU WA TA'ALA                              *
 *  This SOURCE CODE is distributed in the hope that it    *
 *  will be useful, but WITHOUT ANY WARRANTY; without even *
 *  the implied warranty of MERCHANTABILITY or             *
 *  FITNESS FOR A PARTICULAR PURPOSE.                      *
 *  However you can use part of this source code in your   *
 *  own software                                           *
 *                                                         *
\***********************************************************/

#include <windows.h>

#define RESERVED 0L


void BrziSamLine(HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, int wid);
void BrziSam(HWND hwnd, HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, COLORREF cref2, int wid);
HFONT CreateSamFont(INT bold, INT w, INT h, BYTE Charset, char *strFaceName);
LPBYTE SamGetRegPath(void);

void BrziSam(HWND hwnd, HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, COLORREF cref2, int wid)
{
   HPEN hPen, hPen2, hOldPen, hOldPen2;
   hPen = CreatePen(PS_SOLID, wid, cref1);
   hPen2 = CreatePen(PS_SOLID, wid, cref2);
   if ((hPen) && (hPen2)) {
	   BOOL bhdc=FALSE;

      if (hdc == NULL) { bhdc=TRUE; hdc = GetDC(hwnd); }
      SetROP2(hdc, R2_COPYPEN);

   	hOldPen = SelectObject(hdc, hPen);
		MoveToEx(hdc, x1, y1, NULL);
   	LineTo(hdc, x1+x2-1, y1);
		MoveToEx(hdc, x1, y1, NULL);
   	LineTo(hdc, x1, y1+y2-1);

   	x1 += x2-1;
   	y1 += y2-1;

      if (hOldPen) SelectObject(hdc, hOldPen);
   	hOldPen2 = SelectObject(hdc, hPen2);
		MoveToEx(hdc, x1, y1, NULL);
   	LineTo(hdc, x1-x2+1, y1);
		MoveToEx(hdc, x1, y1, NULL);
   	LineTo(hdc, x1, y1-y2+1);

      if (hOldPen2) SelectObject(hdc, hOldPen2);
      if (bhdc == TRUE) ReleaseDC(hwnd, hdc);
   	DeleteObject(hPen);
   	DeleteObject(hPen2);
   }
}
void BrziSamLine(HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, int wid)
{
   HPEN hPen, hOldPen;

   if ((hPen = CreatePen(PS_SOLID, wid, cref1)) != NULL) {
      SetROP2(hdc, R2_COPYPEN);
   	hOldPen = SelectObject(hdc, hPen);

		MoveToEx(hdc, x1, y1, NULL);
   	LineTo(hdc, x1+x2, y1+y2);

      if (hOldPen) SelectObject(hdc, hOldPen);
   }
   if (hPen) DeleteObject(hPen);
}

HFONT CreateSamFont(INT bold, INT w, INT h, BYTE Charset, char *strFaceName)
{
   HFONT sf;
   LOGFONT logfontTemp;

   logfontTemp.lfWidth                    = w;
	logfontTemp.lfHeight                   = h;
   logfontTemp.lfEscapement               = 0;
   logfontTemp.lfOrientation              = 0;
   logfontTemp.lfWeight                   = bold;
   logfontTemp.lfItalic                   = FALSE;
   logfontTemp.lfUnderline                = FALSE;
   logfontTemp.lfStrikeOut                = FALSE;
   logfontTemp.lfCharSet                  = Charset;
   logfontTemp.lfOutPrecision             = 3;
   logfontTemp.lfClipPrecision            = 2;
   logfontTemp.lfQuality                  = 1;
   logfontTemp.lfPitchAndFamily           = 34;
   if (strFaceName != NULL) strcpy(logfontTemp.lfFaceName, strFaceName);
   else ZeroMemory(logfontTemp.lfFaceName, sizeof(logfontTemp.lfFaceName));
   sf = CreateFontIndirect(&logfontTemp);
   return sf;
}
LPBYTE SamGetRegPath(void)
{
	char NamesKey[256];
	const LPTSTR SecondMatch = TEXT("Path");
   REGSAM dwValueType;
   HKEY hKey=HKEY_LOCAL_MACHINE;
   BYTE dwHelpItems[512];
   DWORD dwBufferSize;

   ZeroMemory(NamesKey, sizeof(NamesKey));
   strcpy(NamesKey, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Islamic Prayers");
   if (ERROR_SUCCESS == RegOpenKeyEx(hKey, NamesKey, 0L, KEY_QUERY_VALUE, &hKey)) {
	   dwBufferSize = sizeof(dwHelpItems);
      dwValueType = REG_SZ;
   	if (ERROR_SUCCESS == RegQueryValueEx(hKey, SecondMatch, 0L, &dwValueType, (LPBYTE)&dwHelpItems, &dwBufferSize)) {
         RegCloseKey(hKey);
         return(*(&dwHelpItems));
      }
      else RegCloseKey(hKey);
   }
   return NULL;
}

